/****** Object:  StoredProcedure [Common].[ApplicationParams_Insert]    Script Date: 01-02-18 11:46:01 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Common].[ApplicationParams_Insert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Common].[ApplicationParams_Insert] AS' 
END
GO

ALTER PROCEDURE [Common].[ApplicationParams_Insert](
    @ApplicationName as varchar(128) = 'Default',
    @ParamName as varchar(64),
    @ParamValue as varchar(max) = NULL ,
    @DefaultValue as varchar(max) = NULL ,
    @ValueCanBeNULL as bit = 0,
    @isDepreciated as bit = 0,
    @ParamDescription as varchar(max) = NULL ,
    @creationdate as datetime = NULL,
    @lastmodified as datetime = NULL
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20171121
     *   Description : Inserts a record into [DatabaseMigration].[Common].[ApplicationParams] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    DECLARE @TranCounter  INT; -- See https://msdn.microsoft.com/fr-be/library/ms188378.aspx
    IF(@creationdate IS NULL)
    BEGIN
        SET @creationdate = GETDATE();
    END;
    IF(@lastmodified IS NULL)
    BEGIN
        SET @lastmodified = GETDATE();
    END;
    BEGIN TRY
        -- INSERT
        INSERT [DatabaseMigration].[Common].[ApplicationParams](
            ApplicationName,
            ParamName,
            ParamValue,
            DefaultValue,
            ValueCanBeNULL,
            isDepreciated,
            ParamDescription,
            creationdate,
            lastmodified
        )
        VALUES (
            @ApplicationName,
            @ParamName,
            @ParamValue,
            @DefaultValue,
            @ValueCanBeNULL,
            @isDepreciated,
            @ParamDescription,
            @creationdate,
            @lastmodified
        );
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
GO



/****** Object:  StoredProcedure [Common].[ApplicationParams_Update]    Script Date: 01-02-18 11:46:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Common].[ApplicationParams_Update]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Common].[ApplicationParams_Update] AS' 
END
GO

ALTER PROCEDURE [Common].[ApplicationParams_Update](
    @ApplicationName as varchar(128) = 'Default',
    @ParamName as varchar(64),
    @ParamValue as varchar(max) = NULL ,
    @DefaultValue as varchar(max) = NULL ,
    @ValueCanBeNULL as bit = 0,
    @isDepreciated as bit = 0,
    @ParamDescription as varchar(max) = NULL ,
    @creationdate as datetime = NULL,
    @lastmodified as datetime = NULL
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20171121
     *   Description : Updates a given record in [DatabaseMigration].[Common].[ApplicationParams] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    DECLARE @TranCounter  INT; -- See https://msdn.microsoft.com/fr-be/library/ms188378.aspx
    IF(@creationdate IS NULL)
    BEGIN
        SET @creationdate = GETDATE();
    END;
    IF(@lastmodified IS NULL)
    BEGIN
        SET @lastmodified = GETDATE();
    END;
    BEGIN TRY
        -- UPDATE
        UPDATE [DatabaseMigration].[Common].[ApplicationParams]
            SET
                ParamValue = ISNULL(@ParamValue, ParamValue),
                DefaultValue = ISNULL(@DefaultValue, DefaultValue),
                ValueCanBeNULL = ISNULL(@ValueCanBeNULL, ValueCanBeNULL),
                isDepreciated = ISNULL(@isDepreciated, isDepreciated),
                ParamDescription = ISNULL(@ParamDescription, ParamDescription),
                creationdate = ISNULL(@creationdate, creationdate),
                lastmodified = ISNULL(@lastmodified, lastmodified)
        WHERE 
            ApplicationName = @ApplicationName AND            ParamName = @ParamName
        ;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
GO



/****** Object:  StoredProcedure [Common].[ApplicationParams_Upsert]    Script Date: 01-02-18 11:45:45 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Common].[ApplicationParams_Upsert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Common].[ApplicationParams_Upsert] AS' 
END
GO

ALTER PROCEDURE [Common].[ApplicationParams_Upsert](
    @ApplicationName as varchar(128) = 'Default',
    @ParamName as varchar(64),
    @ParamValue as varchar(max) = NULL ,
    @DefaultValue as varchar(max) = NULL ,
    @ValueCanBeNULL as bit = 0,
    @isDepreciated as bit = 0,
    @ParamDescription as varchar(max) = NULL ,
    @creationdate as datetime = NULL,
    @lastmodified as datetime = NULL
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20171121
     *   Description : Inserts or updates a record into [DatabaseMigration].[Common].[ApplicationParams] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    DECLARE @TranCounter  INT; -- See https://msdn.microsoft.com/fr-be/library/ms188378.aspx
    IF(@creationdate IS NULL)
    BEGIN
        SET @creationdate = GETDATE();
    END;
    IF(@lastmodified IS NULL)
    BEGIN
        SET @lastmodified = GETDATE();
    END;
    BEGIN TRY
        -- Choose between INSERT AND UPDATE
        IF( 0 = (SELECT COUNT(*) FROM [DatabaseMigration].[Common].[ApplicationParams] WHERE 
                ApplicationName = @ApplicationName AND            ParamName = @ParamName
            )
        )
        BEGIN
            EXEC [DatabaseMigration].[Common].[ApplicationParams_Insert]
                      @ApplicationName = @ApplicationName,
                      @ParamName = @ParamName,
                      @ParamValue = @ParamValue,
                      @DefaultValue = @DefaultValue,
                      @ValueCanBeNULL = @ValueCanBeNULL,
                      @isDepreciated = @isDepreciated,
                      @ParamDescription = @ParamDescription,
                      @creationdate = @creationdate,
                      @lastmodified = @lastmodified
            ;
        END;
        ELSE
        BEGIN
            EXEC [DatabaseMigration].[Common].[ApplicationParams_Update]
                      @ApplicationName = @ApplicationName,
                      @ParamName = @ParamName,
                      @ParamValue = @ParamValue,
                      @DefaultValue = @DefaultValue,
                      @ValueCanBeNULL = @ValueCanBeNULL,
                      @isDepreciated = @isDepreciated,
                      @ParamDescription = @ParamDescription,
                      @creationdate = @creationdate,
                      @lastmodified = @lastmodified
            ;
        END;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
GO

